/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet;

import java.util.function.Function;
import java.util.function.Supplier;
import mcjty.lib.modules.IModule;
import mcjty.lib.modules.Modules;
import mcjty.xnet.apiimpl.XNetApi;
import mcjty.xnet.modules.cables.CableModule;
import mcjty.xnet.modules.controller.ControllerModule;
import mcjty.xnet.modules.facade.FacadeModule;
import mcjty.xnet.modules.facade.client.ClientSetup;
import mcjty.xnet.modules.router.RouterModule;
import mcjty.xnet.modules.various.VariousModule;
import mcjty.xnet.modules.wireless.WirelessRouterModule;
import mcjty.xnet.setup.Config;
import mcjty.xnet.setup.ModSetup;
import mcjty.xnet.setup.Registration;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="xnet")
public class XNet {
    public static final String MODID = "xnet";
    public static final ModSetup setup = new ModSetup();
    public static XNet instance;
    private final Modules modules = new Modules();
    public static final XNetApi xNetApi;

    public XNet() {
        instance = this;
        this.setupModules();
        Config.register(this.modules);
        Registration.register();
        IEventBus modbus = FMLJavaModLoadingContext.get().getModEventBus();
        modbus.addListener(setup::init);
        modbus.addListener(arg_0 -> ((Modules)this.modules).init(arg_0));
        modbus.addListener(this::processIMC);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modbus.addListener(arg_0 -> ((Modules)this.modules).initClient(arg_0));
            modbus.addListener(ClientSetup::registerBlockColor);
        });
    }

    private void setupModules() {
        this.modules.register((IModule)new CableModule());
        this.modules.register((IModule)new ControllerModule());
        this.modules.register((IModule)new FacadeModule());
        this.modules.register((IModule)new RouterModule());
        this.modules.register((IModule)new WirelessRouterModule());
        this.modules.register((IModule)new VariousModule());
    }

    private void processIMC(InterModProcessEvent event) {
        event.getIMCStream().forEach(message -> {
            if ("getXNet".equalsIgnoreCase(message.getMethod())) {
                Supplier supplier = message.getMessageSupplier();
                ((Function)supplier.get()).apply(xNetApi);
            }
        });
    }

    static {
        xNetApi = new XNetApi();
    }
}

